#ifndef CONSOLE_H
#define CONSOLE_H

#include <core/ports.h>
#include <stdarg.h>

#define VIDEO_MEMORY_ADDRESS 0xb8000
#define SCREEN_WIDTH 80
#define SCREEN_HEIGHT 25

// Define text colors as an enum
typedef enum {
    BLACK = 0x0,
    BLUE = 0x1,
    GREEN = 0x2,
    CYAN = 0x3,
    RED = 0x4,
    MAGENTA = 0x5,
    BROWN = 0x6,
    LIGHT_GRAY = 0x7,
    DARK_GRAY = 0x8,
    LIGHT_BLUE = 0x9,
    LIGHT_GREEN = 0xA,
    LIGHT_CYAN = 0xB,
    LIGHT_RED = 0xC,
    LIGHT_MAGENTA = 0xD,
    YELLOW = 0xE,
    WHITE = 0xF
} TextColor;

void printf(TextColor color, const char* format, ...);
void clearScreen();
void scrollScreen();
TextColor combineColors(TextColor foreground, TextColor background);

#define DEBUG_LOG(format, ...) DebugPrintf("[DEBUG]", format, ##__VA_ARGS__)
#define PRINT(tag, format, ...) MSGPrintf(LIGHT_BLUE, tag, format, ##__VA_ARGS__)

void DebugPrintf(const char* tag, const char* format, ...);
void MSGPrintf(TextColor cTag, const char* tag, const char* format, ...);


#endif // CONSOLE_H